<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require 'include/empresa.php';
require 'include/formulario.php';
require 'include/cliente.php';
require 'include/horas.php';
?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <title>Estado de Cuenta por Cliente</title>
	
	<link href="css/main.css" rel="stylesheet">
	<link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
	<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.10/css/jquery.dataTables.min.css">
	<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.1.1/css/buttons.dataTables.min.css">
    <!-- Bootstrap -->
    <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet">

    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
      <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
	<!--<base href="localhost/reportes">-->
	</head>
  <body>
  <nav class="navbar navbar-default">
	  <div class="container-fluid">
		<!-- Brand and toggle get grouped for better mobile display -->
		<div class="navbar-header">
		  <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1" aria-expanded="false">
			<span class="sr-only">Toggle navigation</span>
			<span class="icon-bar"></span>
			<span class="icon-bar"></span>
			<span class="icon-bar"></span>
		  </button>
		  <a class="navbar-brand" href="#">Reportes CRM ARIA++</a>
		</div>

		<!-- Collect the nav links, forms, and other content for toggling -->
		<div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
		  <ul class="nav navbar-nav">
			<li><a href="/reportes">Inicio</a></li>
			<li class="active"><a href="estado_cuenta.php">Estado de Cuenta <span class="sr-only">(current)</span></a></li>
			<li><a href="directorio.php">Directorio de Clientes</a></li>
			<li><a href="avance_horas.php">Avance por Horas</a></li>
		  </ul>
		</div><!-- /.navbar-collapse -->
	  </div><!-- /.container-fluid -->
	</nav>
	<div class="container">
		<div id="noprint">
	  <div class="row">
			<h1 class="col-md-12">ESTADO DE CUENTA POR CLIENTE</h1>
		</div>
		<div class="row form">
			<form role="form" method="GET" action="">
				<div class="row">
					<div class="form-group col-md-4">
						<span>Compañia: </span>
						<select id="empresa" name="empresa" class="form-control">
						<option default value="">Escoja Una</option>
						<?
						$empresas = Empresa::getAll();
						foreach($empresas as $empresa){?>
						<option value="<? echo($empresa['id_clientes']); ?>"><? echo($empresa['nombre']); ?></option>
						<?}?>
						</select>
					</div>
					<div class="form-group col-md-4">
						<span>Desde: </span>
						<input name="desde" class="form-control" type="text" id="datepicker1">
					</div>
					<div class="form-group col-md-4">
						<span>Hasta: </span>
						<input name="hasta" class="form-control" type="text" id="datepicker2">
					</div>
				</div>
				<div class="row-fluid">
					<span class="col-md-5"></span>
					<input type="submit" name="submit" value="Consultar" class="col-md-2 btn btn-primary" style="margin-bottom: 30px;">
					<span class="col-md-5"></span>
				</div>
			</form>
		</div>
		</div>
		<?
				if(isset($_GET['submit']) && $_GET['empresa'] != "" && $_GET['desde'] != "" && $_GET['hasta'] != ""){ 
					$idcliente = $_GET['empresa'];
					$desde = $_GET['desde'];
					$hasta = $_GET['hasta'];
					$hmantenimiento = array();
					$hgarantia = array();
					$htotal = array();
					$formularios = Formulario::getEstadocuenta($idcliente, $desde, $hasta);
			?>
		<div class="row titulo_reporte">
			<h2>Estado de Cuenta</h2>
			<h2 style="text-transform: uppercase;"><?php echo(Empresa::getNombre($idcliente));?></h2>
		</div>
		<div class="row titulo_reporte">
			<p>Desde: <?php echo($desde);?> Hasta: <?php echo($hasta);?></p>
		</div>
		<div class="row-fluid" style="max-width: 80%; margin-left: auto; margin-right: auto;">
			<div class="col-sm-12">
			<a href="print_estado_cuenta.php?imprimir=1&cliente=<?php echo($idcliente); ?>&desde=<?php echo($desde);?>&hasta=<?php echo($hasta);?>" class="btn btn-primary">Exportar a PDF</a>
				<table id="formularios" class="table-hover table-bordered">
					<thead>
						<th class="col-md-1">ID FORM.</th><th class="col-md-8">DESCRIPCION</th><th class="col-md-2">FECHA SOLUCIÓN</th><th class="col-md-1">HORAS DESARROLLO</th>
					</thead>
					<tbody>
						<?
						foreach($formularios as $formulario){
							array_push($htotal, $formulario['tiempo_facturado']);
							if ($formulario["clasificacion_requerimiento"]==7){
								array_push($hgarantia, $formulario['tiempo_facturado']);
							}else{
								array_push($hmantenimiento, $formulario['tiempo_facturado']);
							} 
						?>
							<tr>
								<td style="text-align: center;">
									<?
										if ($formulario["clasificacion_requerimiento"]==7){
											echo "*";
										} 
										echo($formulario['id_formulario']);
									?>
								</td>
								<td>
									<? 
										echo($formulario['requerimiento']);
									?>
								</td>
								<td style="text-align: center;">
									<? 
										echo($formulario['fecha_solucion']); 
									?>
								</td>
								<td style="text-align: center;">
									<?
										echo(substr($formulario['tiempo_facturado'],0,5));
									?>
								</td>
							</tr>
						<?}?>
					</tbody>
				</table>
				<div class="row">
					<div class="col-md-6">
						<p>* Requerimientos tipo garantía.</p>
					</div>
					<div class="col-md-6" style="text-align: right; padding-right: 100px;">
						<b>Total Horas Atendidas: <?
										echo(Horas::Sumar($htotal));?></b>
					</div>
				</div>
			</div>
		</div>
		<div class="row-fluid">
			<div class="col-sm-4"></div>
			<div class="col-sm-4">
				<table class="table-bordered table-hover" style="margin-top:20px;">
					<tbody>
						<tr>
							<td>Horas contratadas:</td>
							<td>
								<?php
									$cupo = Cliente::getCupoHoras($idcliente);
									$hcupo = $cupo[0]['cupo_horas'].":00";
									echo($hcupo);
								?>
							</td>
						</tr>
						<tr>
							<td>
								Horas atendidas mantenimiento:
							</td>
							<td>
								<?
									$hmant = Horas::Sumar($hmantenimiento);
									echo($hmant);
								?>
							</td>
						</tr>
						<tr>
							<td>
								Horas atendidas garantía:
							</td>
							<td>
								<?
									echo(Horas::Sumar($hgarantia));
								?>
							</td>
						</tr>
						<tr>
							<td>
								Horas adicionales:
							</td>
							<td>
								<?
									$horas = Horas::Adicionales($hmant, $hcupo);
									
									echo($horas['adicionales']);
								?>
							</td>
						</tr>
						<tr>
							<td>
								Horas pendientes de atención:
							</td>
							<td>
								<?
									echo($horas['pendientes']);
								?>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<div class="col-sm-4"></div>
		</div>
		</div>
	<?
			}
	?>

    <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
    <!-- Include all compiled plugins (below), or include individual files as needed -->
    <script src="bootstrap/js/bootstrap.min.js"></script>
	<script src="//code.jquery.com/ui/1.11.4/jquery-ui.js"></script>
	<script src="https://cdn.datatables.net/1.10.10/js/jquery.dataTables.min.js"></script>
	<script src="https://cdn.datatables.net/buttons/1.1.1/js/dataTables.buttons.min.js"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/2.5.0/jszip.min.js"></script>
	<script src="https://cdn.rawgit.com/bpampuch/pdfmake/0.1.18/build/pdfmake.min.js"></script>
	<script src="https://cdn.rawgit.com/bpampuch/pdfmake/0.1.18/build/vfs_fonts.js"></script>
	<script src="https://cdn.datatables.net/buttons/1.1.1/js/buttons.html5.min.js"></script>
	<script>
		$(document).ready(function() {
			$('#formularios').DataTable({
				"order": [[ 2, "asc" ]], 
				"paging": false,
				dom: 'Bfrtip',
				language: {
					url: 'https://cdn.datatables.net/plug-ins/1.10.10/i18n/Spanish.json'
				},
				buttons: [
						'excel'
				]
			});
		} );
	</script>
	<script>
		$.datepicker.regional['es'] = {
		 closeText: 'Cerrar',
		 prevText: '<Ant',
		 nextText: 'Sig>',
		 currentText: 'Hoy',
		 monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
		 monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
		 dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
		 dayNamesShort: ['Dom','Lun','Mar','Mié','Juv','Vie','Sáb'],
		 dayNamesMin: ['Do','Lu','Ma','Mi','Ju','Vi','Sá'],
		 weekHeader: 'Sm',
		 firstDay: 1,
		 isRTL: false,
		 showMonthAfterYear: false,
		 yearSuffix: ''
		 };
		 $.datepicker.setDefaults($.datepicker.regional['es']);
			  $(function() {
				$( "#datepicker1" ).datepicker({ dateFormat: 'yy-mm-dd' });
			  });
	</script>
	<script>
			  $(function() {
				$( "#datepicker2" ).datepicker({ dateFormat: 'yy-mm-dd' });
			  });
	</script>
  </body>
</html>